<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\CategoryModel;

class Category extends BaseController
{
    use ResponseTrait;
    public function index()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");   
        $rules = [
                'limit' => ['rules' => 'required|min_length[1]|numeric'],
                'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
            ];
        if($this->validate($rules)){
            $model = new CategoryModel;
            try
            {
                $search = $this->request->getPost('search');
                $limit = $this->request->getPost('limit');
                $status = $this->request->getPost('status');
                if($search == ''){
                  $paginateData = $model->where('status',$status)->paginate($limit);
                }else{
                  $paginateData = $model->select('*')
                      ->where('status',$status)
                      ->Like('category_name', $search)
                      ->paginate($limit);
                }
                if(!empty($paginateData))
                {
                    $pager = service('pager');
                    $total = $pager->getTotal();
                    $next = $pager->getNextPageNum();
                    $prev = $pager->getPreviousPageNum();
                    $data = [
                          'j_list' => $paginateData,
                          'next_page' => $next,
                          'prev_prev' => $prev,
                          'total' => $total,
                        ];
                }
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => [$data]], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function addCategory()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'category_name' => ['rules' => 'required|min_length[4]|max_length[255]|is_unique[tbl_category.category_name]'],
        ];
        if($this->validate($rules)){
            $model = new CategoryModel();
            $data = [
                'category_name'    => $this->request->getPost('category_name'),
                'status'    => 1,
            ];
            try {
              $insert=$model->insert($data);
              return $this->respond(['status'=>1,'message' => 'Create Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Get Single Row Details
    public function getSingleDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'id' => ['rules' => 'required|min_length[1]|numeric'],
            ];
        if($this->validate($rules)){
            $model = new CategoryModel;
            try
            {
                $id = $this->request->getPost('id');
                $data = $model->find($id);
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Update category Details
    public function editCategory()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'category_name' => ['rules' => 'required|min_length[4]|max_length[255]'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new CategoryModel;
            $id = $this->request->getPost('id');
            $data = [
                'category_name'    => $this->request->getPost('category_name'),
                'status'    => $this->request->getPost('status'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Update category Status
    public function statusUpdate()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new CategoryModel;
            $id = $this->request->getPost('id');
            $data = [
                'status'    => $this->request->getPost('status'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    // all list
    public function allList()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $model = new CategoryModel;
        try
        {
            $search = $this->request->getPost('search');
            
            if($search == ''){
              $paginateData = $model->select('id,category_name')->where('status',1)->findAll();
            }else{
              $paginateData = $model->select('id,category_name')
                              ->where('status',1)
                              ->Like('category_name', $search)
                              ->findAll();
            }
            if(!empty($paginateData))
            {
                return $this->respond(['status'=>1,'message' => "Sussess",'data' => $paginateData], 200);
            }
            else
            {
                return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
            }

        }
        catch (\Exception $e) {
          return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
        }
    }
    public function getSingleData()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $model = new CategoryModel;
        try
        {
            $data = $model->select('*')->where('status',1)->orderBy('id','asc')->paginate(1);
            if(!empty($data))
            {
                return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
            }
            else
            {
                return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
            }

        }
        catch (\Exception $e) {
          return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
        }
    }
}
