<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\CategoryModel;
use App\Models\ProductsModel;
use App\Models\OrderModel;

use App\Models\TokenModel;
use \Firebase\JWT\JWT;

class Dashboard extends BaseController
{
    use ResponseTrait;

    public function index()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        try{
            //Category
            $cModel = new CategoryModel;
            $categorycount=$cModel->select('id')->where('status',1)->countAllResults();

            //product
            $pmodel = new ProductsModel;
            $productcount=$pmodel->select('id')->where('status',1)->countAllResults();

            //Order
            $omodel = new OrderModel;
            $ordercount=$omodel->select('id')->countAllResults();

            $orevenue = $omodel->select('SUM(total_amount) as revenue')->findAll();

            $revenue =!empty($orevenue[0]['revenue'])?$orevenue[0]['revenue']:'0';

            $counts =array('categorycount'=>$categorycount,
                            'productcount'=>$productcount,
                            'ordercount'=>$ordercount,
                            'revenue'=>$revenue,
                        );
         return $this->respond(['status'=>1,'message' => 'Success','data'=>$counts,'errors'=>[]], 200);
        }
        catch (\Exception $e) {
          return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
        }
    }
    public function updateToken()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'plan_days' => ['rules' => 'required'],
                'key' => ['rules' => 'required'],
                'validdate' => ['rules' => 'required'],
            ];
            // echo "aaaa";
        if($this->validate($rules)){
            $tokenModel = new TokenModel();
            try
            {
                $key = $this->request->getPost('key');
                $validdate = $this->request->getPost('validdate');
                $plan_days = $this->request->getPost('plan_days');

                $iat = time(); 
                $exp = $iat + 60 * 60 * 24 * $plan_days;
                // exit;
                $payload = array(
                    "iss"  => "Issuer of the JWT",
                    "aud"  => "Audience that the JWT",
                    "sub"  => "Subject of the JWT",
                    "iat"  => $iat,
                    "exp"  => $exp,
                    "site" => "Billing",
                );
                $tokenkey = JWT::encode($payload, $key, 'HS256');

                // Expiry date
                $cur_date    = strtotime('Y-m-d');
                $tokencheck = $tokenModel->findAll();
                if(empty($tokencheck))
                {
                        $data = [
                            'token'    => $tokenkey,
                            'mkey'    => $key,
                            'validdate' => $validdate
                        ];
                    try{
                        $tokenModel->insert($data);
                    }catch(\Exception $e)
                    {
                        return $this->respond(['status' => 0,'message' => $e->getMessage(),'data' => $data,'errors' => []], 200);
                    }
                }
                else
                {
                    $id = $tokencheck[0]['id'];
                    $data = [
                            'token'    => $tokenkey,
                            'mkey'    => $key,
                            'validdate' => $validdate
                        ];
                    try {
                      $update=$tokenModel->where('id', $id)->set($data)->update();
                      return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>$data,'errors'=>[]], 200);
                    }
                    catch (\Exception $e) {
                      return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
                    }
                }
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
}
