<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddCategory extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
            'type' => 'BIGINT',
            'constraint' => 255,
            'unsigned' => true,
            'auto_increment' => true
                        ],
            'category_name' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
                    ],
            'status' => [
            'type' => 'INT',
            'constraint' => '11',
                    ],
            'created_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
            'updated_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('tbl_category');
    }
  
    public function down()
    {
        $this->forge->dropTable('tbl_category');
    }
}
