<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddProducts extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
            'type' => 'BIGINT',
            'constraint' => 255,
            'unsigned' => true,
            'auto_increment' => true
                        ],
            'categoryid' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'itemid' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'name' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'url' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'imageUrl' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'packageName' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'unitPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'discountPer' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'discountPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'sellingPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'addtoCart' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'showDetail' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'availableStatus' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'maxQty' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'availableStock' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'inventoryLookup' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'refundStatus' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'subscribeStatus' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'status' => [
            'type' => 'INT',
            'constraint' => '11',
                    ],
            'created_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
            'updated_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('tbl_products');
    }
  
    public function down()
    {
        $this->forge->dropTable('tbl_products');
    }
}
