<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddCartItems extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
            'type' => 'BIGINT',
            'constraint' => 255,
            'unsigned' => true,
            'auto_increment' => true
                        ],
            'cart_session' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'product_id' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'packageName' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'unitPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'discountPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'sellingPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'qty' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'totunitPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'totdiscountPrice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'total' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'status' => [
            'type' => 'INT',
            'constraint' => '11',
                    ],
            'created_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
            'updated_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('tbl_cart_items');
    }
  
    public function down()
    {
        $this->forge->dropTable('tbl_cart_items');
    }
}
