<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Category extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->library('encryption');
		$this->load->helper('url');
	}
	public function index()
	{
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
		$method   = $this->input->post('method');

        if($method == '_dataList')
        {
        	$search   = $this->input->post('search');
        	$status   = $this->input->post('status');
        	$page   = $this->input->post('page');
        	$limitval   = $this->input->post('limitval');

        	$cur_status = isset($status)?$status:'1';
            $cur_page   = isset($page)?$page:'1';

            $where = array(
                'limit'  => $limitval,
                'status' => $cur_status,
                'search' => $search,
            );
            $url      = API_URL."api/category/list?page=".$cur_page;
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);exit;
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                	// print_r($data['body']['data'][0]['j_list']);
                    $data_list = !empty($data['body']['data'][0]['j_list'])?$data['body']['data'][0]['j_list']:[];
                    if($data_list)
                    {
	                    $next_page = zero_check( $data['body']['data'][0]['next_page']);
	                    $prev_page = zero_check( $data['body']['data'][0]['prev_prev']);
	                    $total     = zero_check( $data['body']['data'][0]['total']);

	                    $pageData = [];
                    
                        $table = '';
                        if($cur_page == '1')
                        {
                        	$i=1;
                        }
                        else
                        {
                        	$i = (($cur_page -1) * $limitval) + 1;
                        }
                        
                        foreach ($data_list as $key => $val) {
                            $id         = empty_check($val['id']);
                            $category_name = empty_check($val['category_name']);
                            $created_at = date_check($val['created_at']);
                            $edit_btn   = '';
                            $status_btn = status_check($val['status']);
                            $edit_btn   = '<div class="overlay-edit">
                                            <a href="'.ADMIN_URL.'/category/manage_edit_form/'.$id.'" class="btn btn-icon btn-primary waves-effect waves-light" style="padding: 8px;"><i class="fas fa-edit"></i></a>
                                         </div>';
			                 // <a href="'.SITE_URL.'state/edit/'.$id.'" class="btn btn-warning waves-effect waves-light" style="padding: 8px;"><i class="icon-pencil"></i></a>
                            $status_btn = update_status($val['status'], $val['id'], 'state', 'status');
                            $table .= '
                                <tr class="row_'.$id.'">
                                    <td>'.$i.'</td>
                                    <td>'.$category_name.'</td>
                                    <td>'.$created_at.'</td>
                                    <td>'.$status_btn.'</td>
                                    <td>'.$edit_btn.'</td>
                                </tr>
                            ';

                            $i++;
                        }

                        $pageData = array('table' => $table);

                        if($prev_page)
                        {
                            $pageData['prev_page'] = '<div data-page="'.$prev_page.'" class="pages btn btn-warning waves-effect waves-light pagination_btn">Previous</div>';
                        }

                        if($next_page)
                        {
                            $pageData['next_page'] = '<div data-page="'.$next_page.'" class="pages btn btn-success waves-effect waves-light pagination_btn">Next</div>';
                        }
                        $res['status']=$data['body']['status'];
						$res['message']=$data['body']['message'];
						$res['data']=$pageData;
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }
                    else
                    {
                    	$res['status']=0;
						$res['message']='Data Not Found';
						$res['data']=[];
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }

                    
                } 
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
        }
        else
        {
        	$page['page_title']   = "Category list";
        	$page['page']         = "Category";
        	$page['method']         = "_dataList";
			$page['pre_title']    = "Category List";
			$page['route']        = "/category/index";
			$data['page_temp']    = $this->load->view('category/manage_list',$page,TRUE);
			$data['view_file']    = "Page_Template";
			$data['currentmenu']  = "category_list";
			$this->bassthaya->load_page_template($data);
        }
	}
	public function manage_form($param1='',$param2='')
	{
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
		$page['page_action'] = 'Craete';
		$page['page_title']   = "Category";
		$page['pre_title']    = "Create Category";
		$page['pre_menu']    = "/category";
		$page['route']       = "/category/create";
		$data['page_temp']    = $this->load->view('category/manage_form',$page,TRUE);
		$data['view_file']    = "Page_Template";
		$data['currentmenu']  = "category_form";
		$this->bassthaya->load_form_template($data);
	}
	public function create($param1='',$param2='')
	{
		$category_name = $this->input->post('category_name');
        $required = array('category_name');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
			$insdata  = array('category_name' => $category_name);
			$url      = API_URL."api/category/create";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$insdata,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=[];
					echo json_encode($res);
					return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
		}
		else
		{
			$res['status']=0;
			$res['message']='Invaild Input';
			$res['data']=[];
			$res['errors']=$errjsonres[0];
			echo json_encode($res);
			return;
		}
	}
    public function manage_edit_form($param1='',$param2='')
    {
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
        
        $where = array(
            'id' => $param1,
        );
        $url      = API_URL."api/category/get_details";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);

        $page['singleDetails'] = [];
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                if($data_list)
                {
                    $page['singleDetails'] = $data_list;
                }
            } 
        }
        $page['page_action'] = 'Edit';
        $page['page_title']   = "Category";
        $page['pre_title']    = "Edit Category";
        $page['pre_menu']    = "/category";
        $page['route']       = "/category/edit";
        $data['page_temp']    = $this->load->view('category/manage_edit_form',$page,TRUE);
        $data['view_file']    = "Page_Template";
        $data['currentmenu']  = "category_form";
        $this->bassthaya->load_form_template($data);
    }
    public function edit($param1='',$param2='')
    {
        $id = $this->input->post('id');
        $category_name = $this->input->post('category_name');
        $status = $this->input->post('status');
        $required = array('id','category_name','status');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
            $insdata  = array('id' => $id,'category_name' => $category_name,'status' => $status);
            $url      = API_URL."api/category/edit";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$insdata,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=[];
                    $res['errors']=[];
                    echo json_encode($res);
                    return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=[];
                    $res['errors']=$data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
                $res['message']='Internal server error';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
        }
        else
        {
            $res['status']=0;
            $res['message']='Invaild Input';
            $res['data']=[];
            $res['errors']=$errjsonres[0];
            echo json_encode($res);
            return;
        }
    }
}
